/********************************************************************
*																	*
*      				 Auto Generated File                            *
*                     												*		
*********************************************************************/

/** include files **/
#include "Testingteam.h"           // base header
#include "message.h"       // InternalMessage ....
#include "distri.h"        // class Distribution
#include "mainsimu.h"      // class MainSimulator
#include "strutil.h"       // str2float( ... )


/*******************************************************************
* Function Name: Testingteam
* Description: constructor
********************************************************************/
Testingteam::Testingteam( const string &name )
: Atomic( name )
, bugout(addOutputPort( "bugout" ))
, bugin(addInputPort( "bugin" ))
, preparationTime( 0, 0, 0, 0 )
{
	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

		if( time != "" )
			preparationTime = time ;
	// read distribution parameters:

	dist = Distribution::create( MainSimulator::Instance().getParameter( description(), "distribution" ) );
	MASSERT( dist ) ;
	for ( register int i = 0; i < dist->varCount(); i++ )
	{
		string parameter( MainSimulator::Instance().getParameter( description(), dist->getVar( i ) ) ) ;
		dist->setVar( i, str2Value( parameter ) ) ;
	}

}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &Testingteam::initFunction()
{
	// [(!) Initialize common variables]
	this->elapsed = Time::Zero;
 	this->timeLeft = Time::Inf;
 	// this->sigma = Time::Inf; // stays in active state until an external event occurs;
 	//this->sigma = Time::Zero; // force an internal transition in t=0;

 	// TODO: add init code here. (setting first state, etc)
 	
 	// set next transition
 	//holdIn( active, this->sigma  ) ;
 	bug = 0;
 	this->passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This method executes when an external event is received.
********************************************************************/
Model &Testingteam::externalFunction( const ExternalMessage &msg )
{
	//[(!) update common variables]	

	this->sigma = nextChange();	
	this->elapsed = msg.time()-lastChange();	
 	this->timeLeft = this->sigma - this->elapsed; 
	
 	if(msg.port() == bugin){
 		bug = msg.value();
		//holdIn( active, Time( static_cast<float>( fabs( distribution().get() ) ) ) );
 		holdIn(active, preparationTime);

 	}
	
	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description: This method executes when the TA has expired, right after the outputFunction has finished.
* 			   The new state and TA should be set.
********************************************************************/
Model &Testingteam::internalFunction( const InternalMessage & )
{
	//TODO: implement the internal function here

	bug = 0;
	this->sigma = Time::Inf; // stays in passive state until an external event occurs;
	holdIn( passive, this->sigma  );
	return *this;

}

/*******************************************************************
* Function Name: outputFunction
* Description: This method executes when the TA has expired. After this method the internalFunction is called.
*              Output values can be send through output ports
********************************************************************/
Model &Testingteam::outputFunction( const InternalMessage &msg )
{
	//TODO: implement the output function here
	// remember you can use sendOutput(time, outputPort, value) function.
	sendOutput( msg.time(), bugout , bug ) ;
	
	return *this;

}

Testingteam::~Testingteam()
{
	delete dist;
	//TODO: add destruction code here. Free distribution memory, etc. 
}
